{-
  Ambidexter is Copyright (c) Prescott K. Turner, 2005. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
-}
module Indent () where
import Text.ParserCombinators.Parsec
import Char

(+++) a b = (try a) <|> b

-- == ## == -- == ## == -- == ## == -- == ## == -- == ## == -- == ## == --
-- Note, the input must be a cut statement!
-- indent :: String -> String
indent inp = unlines $ either (const []) id $ parse stmt "" inp
  where
    trm = do
	body <- bracketed +++ cornered +++ abstract +++ variable +++ other
	tp <- opttype
	return $ if null tp then body else body ++ [tp]
    cotrm = do
	body <- coabstract +++ first +++ use +++ covariable +++ other
	tp <- opttype
	return $ if null tp then body else body ++ [tp]
    bracketed = do
	char '['
	i1 <- cotrm
	i2 <- plnend
	return $ ["["] ++ i i1 ++ i2
    plnend = do
	mapM_ char "]pln"
	return ["]pln"]
    opttype = typ +++ return ""
    typ = do
	char ':'
	char ':'
	tp <- type'
	return $ ":" ++ tp
    type' = bintype +++ nottype +++ typevar
    bintype :: Parser String
    bintype = do
	char '('
	tp1 <- type'
	char ')'
	op <- char '&' +++ char '|'
	char '('
	tp2 <- type'
	char ')'
	return $ "(" ++ tp1 ++ ")" ++ [op] ++ "(" ++ tp2 ++ ")"
    nottype = do
	char '~'
	char '('
	tp <- type'
	char ')'
	return $ "~(" ++ tp ++ ")"
    typevar = do
	tp <- many1 (satisfy (\ch -> isDigit ch || ch == '_' || isAlpha ch))
	return tp
    i = map (\s -> "  " ++ s)
    coabstract = do
	v <- many1 (satisfy isAlpha)
	char '.'
	char '('
	s <- stmt
	char ')'
	return $ [v ++ ".("] ++ s ++ [")"]
    abstract = do
	char '('
	s <- stmt
	char ')'
	char '.'
	v <- many1 (satisfy isAlpha)
	return $ ["("] ++ s ++ [")." ++ v]
    cornered = do
	char '<'
	i1 <- trm
	char ','
	i2 <- trm
	mapM char ">par"
	return $ ["<"] ++ i i1 ++ [","] ++ i i2 ++ [">par"]
    first = do
	tag <- mapM char "fst" +++ mapM char "snd"
	i1 <- (do
	    char '['
	    i1 <- cotrm
	    char ']'
	    return i1) +++ return ["!!! i1 failure in fst/snd"]
	return $ [tag ++ "["] ++ i i1 ++ ["]"]
    use = do
	tag <- mapM char "use"
	i1 <- (do
	    char '<'
	    i1 <- trm
	    char '>'
	    return i1) +++ return ["!!! trm failure in use"]
	return $ [tag ++ "<"] ++ i i1 ++ [">"]
    variable = do
	tag <- mapM char "Variable_:"
	v <- many1 (satisfy isAlpha)
	return [v]
    covariable = do
	tag <- mapM char "Covariable_:"
	v <- many1 (satisfy isAlpha)
	return [v]
    other :: Parser [String]
    other = do
	oth <- many1 $ satisfy (not . (`elem` "()[]<>*,")) +++ single_colon
	return [oth]
      where
	single_colon = do
	    char ':'
    stmt :: Parser [String]
    stmt = do
	i1 <- trm
	mapM char "* " +++ mapM char "*" +++ mapM char " * "
	i2 <- cotrm +++ return ["!!! cotrm failure"]
	return $ i i1 ++ ["*"] ++ i i2

crunch = "[b.(Variable_:b*fst[square.(Variable_:b*snd[use<(Variable_:square*use<<3,[a]pln>par>).a>])])]pln * use<<(([a.(Variable_:a*fst[e.(Variable_:a*snd[use<[use<Variable_:e>]pln>])])]pln*use<<[a.(Variable_:a*fst[n.(Variable_:a*snd[use<[use<(void*s.(put_newline s*z)).z>]pln>])])]pln,[b]pln>par>).b*use<[c]pln>).c,[z.(Variable_:z*use<[s.(run2 s*exit)]pln>)]pln>par>"
crash = "([z.(Variable_:z::(String)&(~(~(~(True))))*fst[y.(Variable_:z::(String)&(~(~(~(True))))*snd[use<[use<(Variable_:y::String*s.(put s*a::True)::String).a::True>::~(True)]pln::~(~(True))>::~(~(~(True)))]::(String)&(~(~(~(True)))))::String]::(String)&(~(~(~(True)))))::(String)&(~(~(~(True))))]pln::~((9)&(~(~(~(1)))))*use<<([d.(Variable_:d::_*fst[tf.(Variable_:d::_*snd[use<((([z.(Variable_:z::(_)&(~(_))*fst[y.(Variable_:z::(_)&(~(_))*snd[use<(Variable_:y::_*s.(select s*x::_)::_).x::_>::~(_)]::(_)&(~(_)))::_]::(_)&(~(_)))::(_)&(~(_))]pln::~((14)&(~(~((12)&(~(~((10)&(~(9)))))))))*use<<Variable_:tf::14,[a::_]pln::_>par::_>::_).a::~((12)&(~(~((10)&(~(9))))))*use<<false::12,[b::_]pln::_>par::_>::_).b::~((10)&(~(9)))*use<<true::10,[c::_]pln::_>par::_>::_).c::9>::_]::_)::_]::_)::_]pln::~((14)&(~(9)))*use<<(([z.(Variable_:z::(_)&(~(_))*fst[y.(Variable_:z::(_)&(~(_))*snd[use<(Variable_:y::_*s.(equals s*x::_)::_).x::_>::~(_)]::(_)&(~(_)))::_]::(_)&(~(_)))::(_)&(~(_))]pln::~((Integer)&(~(~((Integer)&(~(14))))))*use<<1::Integer,[a::_]pln::_>par::_>::_).a::~((Integer)&(~(14)))*use<<1::Integer,[b::_]pln::_>par::_>::_).b::14,[e::_]pln::_>par::_>::_).e::9,[f::_]pln::_>par::_>::_).f::~(~(1))*z.(Variable_:z::_*use<[s.(run2 s*exit::True)::_]pln::_>::_)::_"
crush = "z * a.(<Variable_:a,[b.(<[c.(<[use<\"zero\">]pln,Variable_:c>par*z.(Variable_:z*fst[use<[d.(<Variable_:d,[f.(Variable_:z*snd[w.(Variable_:f*use<Variable_:w>)])]pln>par*bif:trace)]pln>]))]pln,[x.(<Variable_:x,[c.(<[d.(<[use<\"zero\">]pln,Variable_:d>par*f.(Variable_:f*fst[use<(Variable_:f*snd[g.(<[h.(<[z]pln,Variable_:h>par*z.(Variable_:z*fst[use<[i.(<Variable_:i,[j.(Variable_:z*snd[w.(Variable_:j*use<Variable_:w>)])]pln>par*bif:trace)]pln>]))]pln,Variable_:g>par*z.(Variable_:z*fst[use<[h.(<Variable_:h,[i.(Variable_:z*snd[w.(Variable_:i*use<Variable_:w>)])]pln>par*bif:prim_abort)]pln>]))]).z>]))]pln,[use<(void*exit).a>]pln>par*snd[w.(Variable_:c*use<Variable_:w>)])]pln>par*bif:put)]pln>par*snd[w.(Variable_:b*use<Variable_:w>)])]pln>par*bif:prim_abort)"
crud = "[use<(void::True*exit::True).a::8>::7]pln::6*b.(<[a.(<[use<void::True>::~(True)]pln::~(~(True)),Variable_:a::11>par::(~(~(True)))&(10)*z.(Variable_:z::(12)&(~(~(~(String))))*fst[x.(<Variable_:x::16,[y.(Variable_:z::(18)&(~(~(~(String))))*snd[w.(Variable_:y::~(~(~(~(String))))*use<Variable_:w::~(~(~(String)))>::~(~(~(~(String)))))::~(~(~(String)))]::(19)&(~(~(~(String)))))::~(~(~(~(String))))]pln::17>par::15*bif:dump::20)::14]::(13)&(~(~(~(String)))))::(~(~(True)))&(~(String)))::~(String)]pln::~(~(String)),Variable_:b::21>par::(~(~(String)))&(9)*x.(Variable_:x::(~(22))&(~(~(23)))*fst[use<(Variable_:x::(~(28))&(~(~(29)))*snd[use<[Covariable_:a::34]pln::~(33)>::~(~(32))]::(~(30))&(~(~(31)))).a::27>::~(26)]::(~(24))&(~(~(25))))::(~(~(String)))&(~(~(1))))::~(~(1))"
crud1 = "<[a.(<[use<void::True>::~(True)]pln::~(~(True)),Variable_:a::11>par::(~(~(True)))&(10)*z.(Variable_:z::(12)&(~(~(~(String))))*fst[x.(<Variable_:x::16,[y.(Variable_:z::(18)&(~(~(~(String))))*snd[w.(Variable_:y::~(~(~(~(String))))*use<Variable_:w::~(~(~(String)))>::~(~(~(~(String)))))::~(~(~(String)))]::(19)&(~(~(~(String)))))::~(~(~(~(String))))]pln::17>par::15*bif:dump::20)::14]::(13)&(~(~(~(String)))))::(~(~(True)))&(~(String)))::~(String)]pln::~(~(String)),Variable_:b::21>par::(~(~(String)))&(9)*x.(Variable_:x::(~(22))&(~(~(23)))*fst[use<(Variable_:x::(~(28))&(~(~(29)))*snd[use<[Covariable_:a::34]pln::~(33)>::~(~(32))]::(~(30))&(~(~(31)))).a::27>::~(26)]::(~(24))&(~(~(25))))::(~(~(String)))&(~(~(1)))"
crud9 = "[c]pln::~(String)*a"
crud8 = "[c]pln::~(~(String))*a"
crud7 = "[a.(<[use<void::True>::~(True)]pln::~(~(True)),Variable_:a::11>par::(~(~(True)))&(10)*z.(Variable_:z::(12)&(~(~(~(String))))*fst[x.(<Variable_:x::16,[y.(Variable_:z::(18)&(~(~(~(String))))*snd[w.(Variable_:y::~(~(~(~(String))))*use<Variable_:w::~(~(~(String)))>::~(~(~(~(String)))))::~(~(~(String)))]::(19)&(~(~(~(String)))))::~(~(~(~(String))))]pln::17>par::15*bif:dump::20)::14]::(13)&(~(~(~(String)))))::(~(~(True)))&(~(String)))::~(String)]pln::~(~(String))*a"
crud6 = "<[a.(<[use<void::True>::~(True)]pln::~(~(True)),Variable_:a::11>par::(~(~(True)))&(10)*z.(Variable_:z::(12)&(~(~(~(String))))*fst[x.(<Variable_:x::16,[y.(Variable_:z::(18)&(~(~(~(String))))*snd[w.(Variable_:y::~(~(~(~(String))))*use<Variable_:w::~(~(~(String)))>::~(~(~(~(String)))))::~(~(~(String)))]::(19)&(~(~(~(String)))))::~(~(~(~(String))))]pln::17>par::15*bif:dump::20)::14]::(13)&(~(~(~(String)))))::(~(~(True)))&(~(String)))::~(String)]pln::~(~(String)),Variable_:b::21>par::(~(~(String)))&(9)*a"
crud2 = "z*x.(Variable_:x::(~(22))&(~(~(23)))*fst[use<(Variable_:x::(~(28))&(~(~(29)))*snd[use<[Covariable_:a::34]pln::~(33)>::~(~(32))]::(~(30))&(~(~(31)))).a::27>::~(26)]::(~(24))&(~(~(25))))::(~(~(String)))&(~(~(1)))"
crud2c = "z*x.(Variable_:x*fst[use<(Variable_:x::(~(28))&(~(~(29)))*snd[use<[Covariable_:a::34]pln::~(33)>::~(~(32))]::(~(30))&(~(~(31)))).a::27>::~(26)]::(~(24))&(~(~(25))))::(~(~(String)))&(~(~(1)))"
crud2b = "z*x.(Variable_:x*fst[use<(Variable_:x*snd[use<[Covariable_:a]pln>::~(~(32))]::(~(30))&(~(~(31)))).a::27>::~(26)]::(~(24))&(~(~(25))))::(~(~(String)))&(~(~(1)))"
crud2a = "z*x.(Variable_:x*fst[use<(Variable_:x*snd[use<[Covariable_:a]pln>]).a>]::(~(24))&(~(~(25))))::(~(~(String)))&(~(~(1)))"
crud3 = "z*x.(Variable_:x*fst[use<(Variable_:x*snd[use<[Covariable_:a]pln>]).a>])::(~(~(String)))&(~(~(1)))"
crud4 = "z*x.(x*fst[use<(x*snd[use<[a]pln)>]).a>])"
crud5 = "z*x.(x*fst[use<(x*snd[use<[a]pln>]).a>])"
