{-
  Ambidexter is Copyright (c) Prescott K. Turner, 2005. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
-}
module Parameters (Parameters(), analyze_args,
	source_file,
	output_file,
	version,
	is_verbose,
	trace_lowering,
	trace_evaluation,
	trace_types,
	trace_unification,
	unify_continue,
	check_types,
	use_lower_IO_type,
	use_lower_function_types,
	show_quick_stack,
	show_long_stack,
	compressed_evaluation,
	unify_limit,
	trace_kind_unification,
	coerce_coterms,
	monad_model,
	default_parameters
	) where
import Data.Char
import Control.Monad
import Maybe

import Type
import Basic

data Parameters = Parameters
	(Maybe FilePath)-- source file
	(Maybe FilePath)-- output file
	Bool		-- version
	Bool		-- verbose
	Bool		-- trace lowering
	Bool		-- trace evaluation
	Bool		-- trace types
	Bool		-- trace unification
	Bool		-- unify continue [upon hitting limit]
	Bool		-- type checking
	UseIOType	-- lower IO type
	UseFunctionTypes -- lower function type
	Bool		-- show stack (quick format)
	Bool		-- show stack (long format)
	Bool		-- compressed evaluation
	Integer		-- limit on unify iterations
	Bool		-- trace unification of kinds
	Bool		-- automatically coerce coterms to terms (add 'plan' operator)
	MonadModel	-- strict vs. original I/O monad

source_file (Parameters x _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _) = x
output_file (Parameters _ x _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _) = x
version (Parameters _ _ x _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _) = x
is_verbose (Parameters _ _ _ x _ _ _ _ _ _ _ _ _ _ _ _ _ _ _) = x
trace_lowering (Parameters _ _ _ _ x _ _ _ _ _ _ _ _ _ _ _ _ _ _) = x
trace_evaluation (Parameters _ _ _ _ _ x _ _ _ _ _ _ _ _ _ _ _ _ _) = x
trace_types (Parameters _ _ _ _ _ _ x _ _ _ _ _ _ _ _ _ _ _ _) = x
trace_unification (Parameters _ _ _ _ _ _ _ x _ _ _ _ _ _ _ _ _ _ _) = x
unify_continue (Parameters _ _ _ _ _ _ _ _ x _ _ _ _ _ _ _ _ _ _) = x
check_types (Parameters _ _ _ _ _ _ _ _ _ x _ _ _ _ _ _ _ _ _) = x
use_lower_IO_type (Parameters _ _ _ _ _ _ _ _ _ _ x _ _ _ _ _ _ _ _) = x
use_lower_function_types (Parameters _ _ _ _ _ _ _ _ _ _ _ x _ _ _ _ _ _ _) = x
show_quick_stack (Parameters _ _ _ _ _ _ _ _ _ _ _ _ x _ _ _ _ _ _) = x
show_long_stack (Parameters _ _ _ _ _ _ _ _ _ _ _ _ _ x _ _ _ _ _) = x
compressed_evaluation (Parameters _ _ _ _ _ _ _ _ _ _ _ _ _ _ x _ _ _ _) = x
unify_limit (Parameters _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ x _ _ _) = x
trace_kind_unification (Parameters _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ x _ _) = x
coerce_coterms (Parameters _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ x _) = x
monad_model (Parameters _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ _ x) = x

default_parameters :: String -> Parameters
default_parameters source_file_name = Parameters (Just source_file_name) Nothing False False False False False False False True (UseLowerIOType True) (UseLowerFunctionTypes True) False False False 2000 False False (UseStrictMonad True)

analyze_args :: [String] -> IO (Maybe Parameters)
analyze_args a0 = do
    let (tl, a1) = extractB ["--tl","--trace-lowering"] a0 False
    let (tr, a2) = extractB ["--tr","--trace"] a1 False
    let (tt, a3) = extractB ["--tt","--trace-types"] a2 False
    let (tc, a4) = extractB ["--tc","--type-check"] a3 True
    let (tu, a5) = extractB ["--tu","--trace-unify"] a4 False
    let (uc, a6) = extractB ["--uc","--unify-continue"] a5 False
    let (tk, a7) = extractB ["--tk","--trace-kind"] a6 False
    let (qs, a8) = extractB ["--qs","--quick-stack"] a7 True
    let (ls, a9) = extractB ["--ls","--long-stack"] a8 False
    let (ce, a10) = extractB ["--ce","--compressed-evaluation"] a9 True
    let (vb, a11) = extractB ["--verbose"] a10 False
    let (vr, a12) = extractB ["-v","--version"] a11 False
    let (lt, a14) = extractB ["--lt","--lower-types"] a12 True
    let uio = UseLowerIOType lt
    let ufunc = UseLowerFunctionTypes lt
    let (sm, a15) = extractB ["--sm","--strict-monad"] a14 False
    let mm = UseStrictMonad sm
    let (m_outfile, a16) = extractS ["-o","--out","--output"] a15
    let (m_unify_limit, a17) = extractN ["--ul","--unify-limit"] a16 50
    let (cc, a18) = extractB ["--cc", "--coerce-coterms"] a17 False
    case a18 of
	_ | sm && not lt -> do
		putStrLn "--no-lower-types requires explicit --no-strict-monad."
		return Nothing
	[inf] -> return $ Just $ Parameters (Just inf) m_outfile vr vb tl tr tt tu uc tc uio ufunc qs ls ce m_unify_limit tk cc mm
	[] | vr -> return $ Just $ Parameters Nothing m_outfile vr vb tl tr tt tu uc tc uio ufunc qs ls ce m_unify_limit tk cc mm
	[] -> do 
		putStrLn "Missing input file name from command line."
		usage
		return Nothing
	others -> do
		putStrLn $ "Unrecognized command line options: " ++ show others ++ "."
		usage
		return Nothing
	
  where
    usage = putStrLn "Usage: ambidexter source.ambi [--version] [--no-tc] [--output file] [--uc] [--ul limit] ..."
    extractB os [] dflt = (dflt, [])
    extractB os args dflt = maybe
			    (dflt, args)
			    (\(passed_args, result, next_args) -> let (result', next_args') = extractB os next_args result in (result', passed_args ++ next_args'))
			    (detect olist args)
      where
	olist = map (\o -> (o, True)) os ++ concatMap maybe_root os
	maybe_root o = case o of
		'-':'-':(root@(r:_)) | isAlphaNum r -> [("--no-" ++ root, False)]
		otherwise -> []
    detect olist args = case post of
				(o:post') -> Just (pre, fromJust (o `lookup` olist), post')
				otherwise -> Nothing
      where
	(pre,post) = break (isJust . (`lookup` olist)) args
    extractS [] args = (Nothing, args)
    extractS (o:os) args = case post of
				(_:ofn:post') -> (Just ofn, pre ++ post')
				otherwise -> extractS os args
      where
	(pre,post) = break (== o) args
    extractN strs args dflt = maybe (dflt, remaining)
			       (\limit_str -> if all isDigit limit_str then (read limit_str ::Integer, remaining)
						else {- Consume no args. -} (dflt, args))
			       m_limit_str
      where
	(m_limit_str, remaining) = extractS strs args
