/*
  harmonograph is Copyright (c) Prescott K. Turner, 2006. All rights reserved.
  It is distributed as free software under the license in the file "License",
  which is included in the distribution.
*/
#ifndef frame_h
#define frame_h

#include "wx/wx.h" 
#include "wx/docview.h"
#include <list>
#include "pendulums.h"

class Canvas;
class TrialDocument;
struct PendulumsState;

class Frame: public wxDocChildFrame
{
public:

    Frame(wxDocument* doc, wxView* view, wxFrame* parent, const wxString& title, const wxPoint& pos, const wxSize& size);

    void OnQuit(wxCommandEvent& event);
    void OnExport(wxCommandEvent& event);
    void OnStart(wxCommandEvent& event);
    void OnStop(wxCommandEvent& event);
    void OnBack(wxCommandEvent& event);
    void OnTimer(wxTimerEvent& event);

    wxTextCtrl *x_length_box;
    wxTextCtrl *y_length_box;
    wxTextCtrl *x_phase_box;
    wxTextCtrl *y_phase_box;
    wxTextCtrl *x_amplitude_box;
    wxTextCtrl *y_amplitude_box;
    wxTextCtrl *friction_box;
    wxButton *start_button;
    wxButton *stop_button;
    wxButton *back_button;
    wxMenu *menuFile;

    wxView      *m_view;

    TrialDocument *get_document();
    void update_parameters(TrialDocument &);
    void update_parameter_boxes(TrialDocument &);
    void refresh();

    void enable_moving(bool is_moving);
    void enable_motion_history(bool has_moved);

    wxTimer timer;
private:
    Canvas    *m_canvas;

    DECLARE_EVENT_TABLE()
};

#endif
